/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.interpartsserver3;

import com.belenus.interpartsserver3.Server;
import com.belenus.interpartsserver3.ServerDispatcher;
import com.belenus.util.Configurator;
import com.belenus.util.StringUtil;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dom4j.Element;

abstract class Responder {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$interpartsserver3$Responder == null ? (class$com$belenus$interpartsserver3$Responder = Responder.class$("com.belenus.interpartsserver3.Responder")) : class$com$belenus$interpartsserver3$Responder));
    private static final Class[] RESPONDER_OUTPUT = new Class[]{class$java$io$OutputStream == null ? (class$java$io$OutputStream = Responder.class$("java.io.OutputStream")) : class$java$io$OutputStream};
    protected HttpServletRequest m_httpServletRequest;
    protected HttpServletResponse m_httpServletResponse;
    protected ServerDispatcher m_serverDispatcher;
    protected Server m_server;
    protected Configurator m_configurator;
    protected String m_compressor;
    private OutputStream m_servletOutputStream;
    private OutputStream m_compressedOutputStream;
    private OutputStream m_outputStream;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$Responder;
    static /* synthetic */ Class class$java$io$OutputStream;

    Responder(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Server server) {
        this(httpServletRequest, httpServletResponse, server.m_serverDispatcher);
        this.m_server = server;
        this.m_configurator = server.m_configurator;
    }

    Responder(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServerDispatcher serverDispatcher) {
        this.m_httpServletRequest = httpServletRequest;
        this.m_httpServletResponse = httpServletResponse;
        this.m_serverDispatcher = serverDispatcher;
        String acceptEncoding = this.m_httpServletRequest.getHeader("Accept-Encoding");
        String[] contentEncodings = StringUtil.split(acceptEncoding, ",");
        for (int contentEncodingsIndex = 0; contentEncodingsIndex < contentEncodings.length; ++contentEncodingsIndex) {
            String testedCompressor;
            String contentEncoding = contentEncodings[contentEncodingsIndex];
            if (contentEncoding == null || contentEncoding.equals("") || !this.m_serverDispatcher.m_compressorMap.containsKey(testedCompressor = contentEncoding.toLowerCase())) continue;
            this.m_compressor = testedCompressor;
            break;
        }
    }

    protected abstract void respond() throws Throwable;

    HttpServletResponse getHttpServletResponse() {
        return this.m_httpServletResponse;
    }

    void setContentType(String contentType) {
        this.m_httpServletResponse.setContentType(contentType);
    }

    OutputStream startOutputStream(boolean compressed, boolean encrypted) {
        try {
            this.m_servletOutputStream = this.m_httpServletResponse.getOutputStream();
        }
        catch (IOException exc) {
            // empty catch block
        }
        this.m_compressedOutputStream = this.m_servletOutputStream;
        this.m_outputStream = this.m_servletOutputStream;
        if (compressed && this.m_compressor != null) {
            try {
                this.m_compressedOutputStream = (FilterOutputStream)((Class)this.m_serverDispatcher.m_compressorMap.get(this.m_compressor)).getConstructor(RESPONDER_OUTPUT).newInstance(this.m_servletOutputStream);
                this.m_httpServletResponse.setHeader("Content-Encoding", this.m_compressor);
                this.m_outputStream = this.m_compressedOutputStream;
            }
            catch (Exception exc) {
                logger.error((Object)exc);
            }
        }
        if (encrypted && this.m_serverDispatcher.m_encryptor != null) {
            try {
                this.m_outputStream = (FilterOutputStream)this.m_serverDispatcher.m_encryptor.getConstructor(RESPONDER_OUTPUT).newInstance(this.m_compressedOutputStream);
                this.m_httpServletResponse.setHeader("Content-Encoding", "encrypted");
            }
            catch (Exception exc) {
                logger.error((Object)exc);
            }
        }
        return this.m_outputStream;
    }

    protected void addText(Element element, String content) {
        if (content != null) {
            element.addText(content);
        }
    }

    protected void addAttribute(Element element, String attributeKey, String attributeValue) {
        if (attributeKey != null && attributeValue != null) {
            element.addAttribute(attributeKey, attributeValue);
        }
    }

    protected String giveContentType(String filename, InputStream in) {
        String contenttype = null;
        int pos = filename.lastIndexOf(".");
        if (pos == -1) {
            if (contenttype == null && this.m_server != null) {
                contenttype = this.m_server.giveMimeType(filename, in, "application/octetstream");
            }
        } else {
            String extention = filename.substring(pos + 1).toLowerCase();
            contenttype = (String)this.m_serverDispatcher.m_contentTypeMap.get(extention);
            if (contenttype == null && this.m_server != null) {
                contenttype = this.m_server.giveMimeType(filename, in, "application/" + extention);
            }
        }
        return contenttype;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

